/** !------------------------------------------------------------------------->
*
*  @file <BusConfiguration>_tx.cpp
*
*  @creationDate 21 November 2024 16:54:49
*
*  @brief 
*    This is a generated BusCfg_tx source file for manual and cyclis PDU triggering.
*    Any changes will be lost, during the next generation cycle
*
*  @author
*
*  @description
*
*  @copyright
*    Copyright 2024, dSPACE GmbH. All rights reserved.
*   
*!-------------------------------------------------------------------------->*/

#include <stdio.h>
#include "BMUtils.h"
#include "StateManager_generated.h"
#include "Bus_Configuration__1__11337.h"
#include "Bus_Configuration__1__11337_tx.h"
#include "BusCfgTx_profiler.h"


#define CURRENT_TIME Bus_Configuration__1__11337_BusCfg_CurrentTime
#define PERIOD 1000
#define TX_PDUS Bus_Configuration__1__11337_BusCfgTxPdus

volatile sint64 CURRENT_TIME;

/* First-time init indicator, prevents multiple StateManager callback registrations, pre-initialized here cause no OnInit function exists. */
static boolean stateManagerCallbacksRegistered = FALSE;
static boolean busCfgTxVariableInitilialized = FALSE;

 /* Array of all TX-PDUs incl. processing states and variables. */
BusCfgTxPdu TX_PDUS[] = {
     {   // ECU: Plant PDU:AngVel_Compressor Priority:0b00000000000000000000000000000000, /* 00000000 */
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            2, 0, TRUE,
        }
    },
    {   // ECU: Controller PDU:cmd_battery_pump Priority:0b00000000001000000000000000000000, /* 00200000 */
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            4, 0, TRUE,
        }
    },
    {   // ECU: Controller PDU:cmd_chiller_bypass Priority:0b00000000010000000000000000000000, /* 00400000 */
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            4, 0, TRUE,
        }
    },
    {   // ECU: Controller PDU:cmd_comp Priority:0b00000000011000000000000000000000, /* 00600000 */
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            4, 0, TRUE,
        }
    },
    {   // ECU: Controller PDU:cmd_fan Priority:0b00000000100000000000000000000000, /* 00800000 */
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            4, 0, TRUE,
        }
    },
    {   // ECU: Controller PDU:cmd_heater Priority:0b00000000101000000000000000000000, /* 00A00000 */
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            4, 0, TRUE,
        }
    },
    {   // ECU: Controller PDU:cmd_motor_pump Priority:0b00000000110000000000000000000000, /* 00C00000 */
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            4, 0, TRUE,
        }
    },
    {   // ECU: Controller PDU:cmd_parallel_serial Priority:0b00000000111000000000000000000000, /* 00E00000 */
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            4, 0, TRUE,
        }
    },
    {   // ECU: Controller PDU:cmd_rad_bypass Priority:0b00000001000000000000000000000000, /* 01000000 */
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            4, 0, TRUE,
        }
    },
    {   // ECU: Plant PDU:EPower_Compressor Priority:0b00000001001000000000000000000000, /* 01200000 */
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            2, 0, TRUE,
        }
    },
    {   // ECU: Plant PDU:i_battery Priority:0b00000001010000000000000000000000, /* 01400000 */
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            2, 0, TRUE,
        }
    },
    {   // ECU: Controller PDU:I_traction Priority:0b00000001011000000000000000000000, /* 01600000 */
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            4, 0, TRUE,
        }
    },
    {   // ECU: Plant PDU:p_chiller Priority:0b00000001100000000000000000000000, /* 01800000 */
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            2, 0, TRUE,
        }
    },
    {   // ECU: Plant PDU:p_cond Priority:0b00000001101000000000000000000000, /* 01A00000 */
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            2, 0, TRUE,
        }
    },
    {   // ECU: Plant PDU:PJoule_battery Priority:0b00000001110000000000000000000000, /* 01C00000 */
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            2, 0, TRUE,
        }
    },
    {   // ECU: Controller PDU:Q_charger Priority:0b00000001111000000000000000000000, /* 01E00000 */
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            4, 0, TRUE,
        }
    },
    {   // ECU: Controller PDU:Q_dcdc Priority:0b00000010000000000000000000000000, /* 02000000 */
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            4, 0, TRUE,
        }
    },
    {   // ECU: Controller PDU:Q_inverter Priority:0b00000010001000000000000000000000, /* 02200000 */
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            4, 0, TRUE,
        }
    },
    {   // ECU: Controller PDU:Q_motor Priority:0b00000010010000000000000000000000, /* 02400000 */
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            4, 0, TRUE,
        }
    },
    {   // ECU: Plant PDU:T_battery1 Priority:0b00000010011000000000000000000000, /* 02600000 */
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            2, 0, TRUE,
        }
    },
    {   // ECU: Plant PDU:T_battery2 Priority:0b00000010100000000000000000000000, /* 02800000 */
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            2, 0, TRUE,
        }
    },
    {   // ECU: Plant PDU:T_battery3 Priority:0b00000010101000000000000000000000, /* 02A00000 */
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            2, 0, TRUE,
        }
    },
    {   // ECU: Plant PDU:T_battery4 Priority:0b00000010110000000000000000000000, /* 02C00000 */
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            2, 0, TRUE,
        }
    },
    {   // ECU: Plant PDU:T_coolant_battery_in Priority:0b00000010111000000000000000000000, /* 02E00000 */
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            2, 0, TRUE,
        }
    },
    {   // ECU: Plant PDU:T_coolant_inverter_out Priority:0b00000011000000000000000000000000, /* 03000000 */
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            2, 0, TRUE,
        }
    },
    {   // ECU: Plant PDU:T_inverter Priority:0b00000011001000000000000000000000, /* 03200000 */
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            2, 0, TRUE,
        }
    },
    {   // ECU: Plant PDU:T_motor Priority:0b00000011010000000000000000000000, /* 03400000 */
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            2, 0, TRUE,
        }
    },
    {   // ECU: Plant PDU:Torque_Compressor Priority:0b00000011011000000000000000000000, /* 03600000 */
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_PLANT_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            2, 0, TRUE,
        }
    },
    {   // ECU: Controller PDU:v_vehicle Priority:0b00000011100000000000000000000000, /* 03800000 */
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_TriggerIPDU,
        BM_BUS_CONFIGURATION__1__11337_1_CONTROLLER_Com_PduEnabledSendCheck,
        E_PENDING_NONE,
        {   // initial period, current period, initial offset, current offset, next timing
            10000, 10000, 
            0, 0, 0
        },
        {   //ComControllerEnable state index, Credits state index, enable bits for com controller
            4, 0, TRUE,
        }
    },
};
#define BUFCFG_MAX_TXPDUS 29

/**************************************************************************************************\
 *** FUNCTION:
 ***     BusCfgTx_ComControllerStateChange()
 *** 
 *** DESCRIPTION:
 ***    This function is called if the state of a ComController gets changed.
 ***
 *** PARAMETERS:
 ***    uint32 index        StateManager index of ComController state
 ***    uint8  newSate      New state of ComController
 ***    uint8  old state    Old state of ComController
 *** 
 *** RETURNS:
 ***     void
\**************************************************************************************************/
static void BusCfgTx_ComControllerStateChange(uint32 index, uint8 newState, uint8 oldState) {
    BusCfgTxPdu* pdu;
    int i;

    POSSIBLE_UNREFERENCED_PARAMETER(oldState);

    PROFILER_START_BusCfgTx_ComControllerStateChange(0, 0);
    if (newState == COM_CONTROLLER_ENABLE) { /* ComController gets enabled */
        for(i = 0; i < BUFCFG_MAX_TXPDUS; i++) {
            pdu = &TX_PDUS[i];
            if (pdu->states.ComControllerStateIndex == index) {
                pdu->states.ControllerState = COM_CONTROLLER_ENABLE;
                pdu->timing.next_time = CURRENT_TIME + pdu->timing.offset;
            }
        }
    }
    else { /* ComController gets disabled */
        for(i = 0; i < BUFCFG_MAX_TXPDUS; i++) {
            pdu = &TX_PDUS[i];
            if (pdu->states.ComControllerStateIndex == index) {
                pdu->states.ControllerState = COM_CONTROLLER_DISABLE;
                pdu->pending = E_PENDING_NONE;
            }
        }
    }
    PROFILER_END_BusCfgTx_ComControllerStateChange(0, 0);
}


/**************************************************************************************************\
 *** FUNCTION:
 ***     Bus_Configuration__1__11337_BusCfgTx_OnStart
 *** 
 *** DESCRIPTION:
 ***     This function is called in OnStart application phase.
 ***
 *** PARAMETERS:
 ***     -/-
 *** 
 *** RETURNS:
 ***     void
\**************************************************************************************************/
void Bus_Configuration__1__11337_BusCfgTx_OnStart() {
    int i;

    PROFILER_CREATE_BusCfgTx_VariableInitialize(Bus_Configuration__1__11337_BusCfgTx_VariableInitialize);
    PROFILER_CREATE_BusCfgTx_BusCfgStateChange(Bus_Configuration__1__11337_BusCfgTx_BusCfgStateChange);
    PROFILER_CREATE_BusCfgTx_ComControllerStateChange(Bus_Configuration__1__11337_BusCfgTx_ComControllerStateChange);
    PROFILER_CREATE_BusCfgTx_TriggerPendingPdus(Bus_Configuration__1__11337_BusCfgTx_TriggerPendingPdus);
    PROFILER_CREATE_BusCfgTx_TriggerPendingFailed("Bus_Configuration__1__11337_BusCfgTx_TriggerPendingPdusFailed");
    PROFILER_CREATE_BusCfgTx_TriggerPendingSucceeded("Bus_Configuration__1__11337_BusCfgTx_TriggerPendingPdusSucceeded");
    PROFILER_CREATE_FINISH;

    if (!stateManagerCallbacksRegistered) {
        StateManager_RegisterCallback_NoTransitions(2, BusCfgTx_ComControllerStateChange);
        StateManager_RegisterCallback_NoTransitions(4, BusCfgTx_ComControllerStateChange);
        stateManagerCallbacksRegistered = TRUE;
    }

    for(i = 0; i < BUFCFG_MAX_TXPDUS; i++) {
        BusCfgTxPdu* pdu = &TX_PDUS[i];
        BusCfgTxPduTiming* timing = &pdu->timing;
        pdu->pending = E_PENDING_NONE;
        timing->next_time = CURRENT_TIME + timing->offset;
    }
}

/**************************************************************************************************\
 *** FUNCTION:
 ***     Bus_Configuration__1__11337_BusCfgTx_OnStop
 *** 
 *** DESCRIPTION:
 ***     This function is called in OnStop application phase.
 ***
 *** PARAMETERS:
 ***     -/-
 *** 
 *** RETURNS:
 ***     void
\**************************************************************************************************/
void Bus_Configuration__1__11337_BusCfgTx_OnStop() {
    busCfgTxVariableInitilialized = FALSE;
}

/**************************************************************************************************\
 *** FUNCTION:
 ***     Bus_Configuration__1__11337_BusCfgTx_VariableInitialize()
 *** 
 *** DESCRIPTION:
 ***    This function is called before the application starts and may be used to extend the
 ***    initialization phase.
 ***
 *** PARAMETERS:
 *** 
 *** RETURNS:
 ***     void
\**************************************************************************************************/
void Bus_Configuration__1__11337_BusCfgTx_VariableInitialize() {
    int i;

    if (!busCfgTxVariableInitilialized) {
        PROFILER_START_BusCfgTx_VariableInitialize(0, 0);

        CURRENT_TIME = 0;

        for(i = 0; i < BUFCFG_MAX_TXPDUS; i++) {
            BusCfgTxPdu* pdu = &TX_PDUS[i];
            BusCfgTxPduTiming* timing = &pdu->timing;
            timing->period = timing->init_period;
            timing->offset = timing->init_offset;
            timing->next_time = CURRENT_TIME + timing->offset;
        }
        PROFILER_END_BusCfgTx_VariableInitialize(0, 0);
        busCfgTxVariableInitilialized = TRUE;
    }
}

/**************************************************************************************************\
 *** FUNCTION:
 ***     Bus_Configuration__1__11337_BusCfgTx_SetPduPeriodOffset()
 *** 
 *** DESCRIPTION:
 ***    This function is called if the value of period or offset of a CyclicTimingControl 
 ***    feature change.
 ***
 *** PARAMETERS:
 ***    PduIdType pduId        Identifier of the PDU
 ***    sint32    period       New period value of the PDU
 ***    sint32    offset       New offset of the PDU
 *** 
 *** RETURNS:
 ***     void
\**************************************************************************************************/
void Bus_Configuration__1__11337_BusCfgTx_SetPduPeriodOffset(PduIdType pduId, sint32 period, sint32 offset) {
    BusCfgTxPduTiming* timing = &TX_PDUS[pduId].timing;

    sint32 delta_offset = offset - timing->offset;
    if (timing->next_time) {
        if (timing->period == 0)
        {
            /* ensure PDU will be send immediately */
            timing->next_time = CURRENT_TIME;
        }
        else 
        {
            timing->next_time = (timing->next_time - timing->period + period + delta_offset);
        }
    }
    timing->period = period;
    timing->offset = offset;
}

/**************************************************************************************************\
 *** FUNCTION:
 ***    Bus_Configuration__1__11337_BusCfgTx_SetPduPending
 *** 
 *** DESCRIPTION:
 ***    This function is called set pending flag of specified PDU.
 ***
 *** PARAMETERS:
 ***    PduIdType pduId        Identifier of the PDU
 *** 
 *** RETURNS:
 ***     E_OK on success, E_NOT_OK if cache is full
\**************************************************************************************************/
Std_ReturnType Bus_Configuration__1__11337_BusCfgTx_SetPduPending(PduIdType pduId) {
    TX_PDUS[pduId].pending = static_cast<BUSCFG_TX_PENDING_ENUM>(TX_PDUS[pduId].pending | E_PENDING_MANUAL);
    return E_OK;
}

/**************************************************************************************************\
 *** FUNCTION:
 ***     Bus_Configuration__1__11337_BusCfgTx_TriggerPendingPdus()
 *** 
 *** DESCRIPTION:
 ***    This function is called once per sample step and sends TX-PDUs if possible/required
 ***
 *** PARAMETERS:
 *** 
 *** RETURNS:
 ***     void
\**************************************************************************************************/
void Bus_Configuration__1__11337_BusCfgTx_TriggerPendingPdus() {
    uint32 i;
    uint8 pdu_disabled_or_locked;
    BusCfgTxPdu* pdu;
    BusCfgTxPduStates* states;
    BusCfgTxPduTiming* timing;

    sint64 checkTime = CURRENT_TIME + PERIOD / 2; // + period/2
    PROFILER_INIT_SKIPPED;
    PROFILER_START_BusCfgTx_TriggerPendingPdus(0, CURRENT_TIME);
    for (i = 0; i < BUFCFG_MAX_TXPDUS; i++) {
        pdu = &TX_PDUS[i];
        states = &pdu->states;
        timing = &pdu->timing;

        /* check credits */
        if (states->CreditsStateIndex >=0 && StateManager_GetState((uint32)states->CreditsStateIndex) <= 0) {
            PROFILER_INC_SKIPPED;
            continue;
        }
            
        /* check timing if not already cyclic-pending and period !=0 and enabled (ComController etc.)*/
        if (checkTime >= timing->next_time) {
            if (!(pdu->pending & E_PENDING_CYCLIC) && timing->period != 0 && states->ControllerState == COM_CONTROLLER_ENABLE) {
                pdu->pending = static_cast<BUSCFG_TX_PENDING_ENUM>(pdu->pending | E_PENDING_CYCLIC);
            }
        }

        /* process pending */
        if (pdu->pending) {
            /* check PDU enable feature and J1939 connection lock */
            if ((pdu_disabled_or_locked = pdu->IsPduEnabled(i)) == PDU_TX_ENABLED) {
                /* Try send out PDU */
                if (pdu->ComTriggerIPDU(i) != E_NOT_OK) {
                    /* re-schedule PDU if not manual triggered */
                    if (pdu->pending & E_PENDING_CYCLIC)
                    {
                        timing->next_time = CURRENT_TIME + timing->period;
                    }
                    pdu->pending = E_PENDING_NONE;
                    PROFILER_TIMESTAMP_BusCfgTx_TriggerPendingSucceeded(1, i);
                }
                else {
                    PROFILER_TIMESTAMP_BusCfgTx_TriggerPendingFailed(1, i);
                }
            }
            else {
                /* check if pdu is disabled by enable feature and NOT by J1939 connection lock */
                if (pdu_disabled_or_locked & PDU_TX_DISABLED) {
                    /* re-schedule PDU if not enabled */
                    if (pdu->pending & E_PENDING_CYCLIC){
                        timing->next_time = CURRENT_TIME + timing->period;
                    }
                    pdu->pending = E_PENDING_NONE;
                    PROFILER_TIMESTAMP_BusCfgTx_TriggerPendingSucceeded(2, i);
                }
            }
        }
    } 
    PROFILER_TIMESTAMP_BusCfgTx_SkippedPdus(0);
    /* Finally increment current time by task period */
    CURRENT_TIME += PERIOD;
    PROFILER_END_BusCfgTx_TriggerPendingPdus(0, 0);
}

